/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.server;

import grymV2.game.server.EventHandler;
import grymV2.game.server.Popup;
import grymV2.game.server.Simulation;
import grymV2.game.server.TimeHandler;
import java.util.ArrayList;

public class Abel
extends Thread {
    private ArrayList<Popup> currentPopups;
    private final EventHandler eventHandler;
    public TimeHandler timeHandler;
    public Simulation simulation;
    private boolean isRunning = true;
    private int sDelay;
    private boolean isSkippingUpdates = true;

    public Abel(int TPS) {
        this.sDelay = 1000 / TPS;
        this.eventHandler = new EventHandler();
        this.timeHandler = new TimeHandler();
        this.simulation = new Simulation();
    }

    public float getTime() {
        return this.timeHandler.gameSeconds();
    }

    public void endGame() {
        this.isRunning = false;
    }

    public ArrayList<Popup> getCurrentPopups() {
        return this.currentPopups;
    }

    @Override
    public void run() {
        while (this.isRunning) {
            try {
                Thread.sleep(this.sDelay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (this.isSkippingUpdates) continue;
            this.eventHandler.tick(this.timeHandler.gameSeconds());
            this.simulation.tick(0.0666f);
        }
    }

    public void startGame() {
        this.timeHandler.startGame();
        this.isSkippingUpdates = false;
    }

    public void pause() {
        this.isSkippingUpdates = true;
        this.timeHandler.pause();
    }

    public boolean isPaused() {
        return this.isSkippingUpdates;
    }

    public void unpause() {
        this.isSkippingUpdates = false;
        this.timeHandler.unpause();
    }
}

