/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.grid;

import grymV2.game.grid.GridLayers;
import grymV2.game.world.Developable;
import grymV2.game.world.GameObject;
import grymV2.game.world.Mutable;
import grymV2.game.world.Rotatable;
import java.util.EnumMap;

public class Tile {
    private final byte x;
    private final byte y;
    private EnumMap<GridLayers, GameObject> layers;

    public Tile(byte x, byte y) {
        this.x = x;
        this.y = y;
        this.layers = new EnumMap(GridLayers.class);
    }

    public byte getCoordX() {
        return this.x;
    }

    public byte getCoordY() {
        return this.y;
    }

    private GameObject tlg(GridLayers layer) {
        return this.layers.get((Object)layer);
    }

    public GameObject getLayer(GridLayers layer) {
        return this.tlg(layer);
    }

    public void setLayer(GridLayers layer, GameObject content) {
        this.layers.put(layer, content);
    }

    public boolean isDevelopable() {
        return this.tlg(GridLayers.BACKGROUND) instanceof Developable;
    }

    public boolean isEmpty(GridLayers layer) {
        return this.tlg(layer) == null;
    }

    public boolean isMutable(GridLayers layer) {
        return this.tlg(layer) instanceof Mutable;
    }

    public boolean isRotatable(GridLayers layer) {
        return this.tlg(layer) instanceof Rotatable;
    }
}

