/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.grid;

import grymV2.game.config.MapSizes;
import grymV2.game.grid.GridLayers;
import grymV2.game.grid.Tile;
import grymV2.game.world.BackgroundGameObject;
import grymV2.game.world.Building;
import grymV2.game.world.ForegroundGameObject;
import grymV2.game.world.GameObject;
import grymV2.game.world.Lake;
import grymV2.game.world.Placeable;
import grymV2.game.world.Road;
import java.util.ArrayList;

public class Grid {
    private final MapSizes size;
    private final byte x;
    private final byte y;
    final ArrayList<ArrayList<Tile>> grid;

    public Grid(MapSizes size) {
        this.size = size;
        this.x = this.size.getX();
        this.y = this.size.getY();
        this.grid = this.gridInit(size);
    }

    private ArrayList<ArrayList<Tile>> gridInit(MapSizes size) {
        ArrayList<ArrayList<Tile>> newGrid = new ArrayList<ArrayList<Tile>>(size.getX());
        for (byte i = 0; i < size.getX(); i = (byte)(i + 1)) {
            newGrid.add(new ArrayList());
            for (byte j = 0; j < size.getY(); j = (byte)(j + 1)) {
                newGrid.get(i).add(new Tile(i, j));
            }
        }
        return newGrid;
    }

    public MapSizes getSize() {
        return this.size;
    }

    public byte getDimensionX() {
        return this.x;
    }

    public byte getDimensionY() {
        return this.y;
    }

    public Tile getTile(byte x, byte y) {
        return this.grid.get(x).get(y);
    }

    public boolean isPlaceable(byte x, byte y) {
        Tile t = this.getTile(x, y);
        return t.isDevelopable() && t.isEmpty(GridLayers.FOREGROUND);
    }

    public boolean isPlaceable(Tile t) {
        byte y;
        byte x = t.getCoordX();
        if (this.isTile(x, y = t.getCoordY())) {
            return this.isPlaceable(x, y);
        }
        return false;
    }

    public boolean isEdge(byte x, byte y) {
        return x == 0 || y == 0 || x == this.x || y == this.y;
    }

    public boolean isTile(byte x, byte y) {
        return x >= 0 && x <= this.x && y >= 0 && y <= this.y;
    }

    public boolean updateTile(byte x, byte y, GameObject newContent, GridLayers layer) {
        Tile t = this.getTile(x, y);
        switch (layer) {
            case BACKGROUND: {
                if (!(newContent instanceof BackgroundGameObject)) {
                    return false;
                }
                if (t.isMutable(layer)) break;
                return false;
            }
            case FOREGROUND: {
                if (!(newContent instanceof ForegroundGameObject)) {
                    return false;
                }
                if (t.isEmpty(GridLayers.BACKGROUND)) {
                    return false;
                }
                if (!t.isMutable(layer)) {
                    return false;
                }
                if (t.getLayer(layer) instanceof Building) {
                    return false;
                }
                if (newContent instanceof Placeable && !this.isPlaceable(t)) {
                    return false;
                }
                if (!(newContent instanceof Road) || !(t.getLayer(GridLayers.BACKGROUND) instanceof Lake)) break;
                return false;
            }
            default: {
                return false;
            }
        }
        t.setLayer(layer, newContent);
        return true;
    }
}

