/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import grymV2.game.client.ui.MenuShape;

public abstract class TextMenuShape
extends MenuShape {
    private String text;
    private float textX;
    private float textY;
    private Color textColor = Color.BLACK;
    private BitmapFont font;
    private GlyphLayout glyph;

    public TextMenuShape(BitmapFont font, float x, float y, float width, float height) {
        super(x, y, width, height);
        this.font = font;
        this.font.setColor(this.textColor);
        this.text = "";
        this.glyph = new GlyphLayout(this.font, "");
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.glyph.setText(this.font, text);
        this.text = text;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        this.font.setColor(textColor);
    }

    public void centreText() {
        this.setTextX(this.getX() + (this.getWidth() - this.glyph.width) / 2.0f);
        this.setTextY(this.getY() + (this.getHeight() + this.glyph.height) / 2.0f);
    }

    public float getTextX() {
        return this.textX;
    }

    public float getTextY() {
        return this.textY;
    }

    public void setTextX(float textX) {
        this.textX = textX;
    }

    public void setTextY(float textY) {
        this.textY = textY;
    }

    public BitmapFont getFont() {
        return this.font;
    }

    public GlyphLayout getGlyph() {
        return this.glyph;
    }

    @Override
    public abstract void draw(ShapeRenderer var1, SpriteBatch var2, Camera var3);
}

