/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import grymV2.game.client.ui.Button;
import grymV2.game.client.ui.TextMenuShape;

public class TextButton
extends TextMenuShape
implements Button {
    private Color altColor = Color.RED;
    private boolean active = false;

    public TextButton(BitmapFont font) {
        this(font, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public TextButton(BitmapFont font, float x, float y, float width, float height) {
        super(font, x, y, width, height);
    }

    @Override
    public void draw(ShapeRenderer shape, SpriteBatch batch, Camera camera) {
        this.centreText();
        shape.setProjectionMatrix(camera.combined);
        shape.begin(ShapeRenderer.ShapeType.Filled);
        shape.setColor(this.active ? this.getAltColor() : this.getColor());
        shape.rect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        shape.end();
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        this.getFont().setColor(this.active ? this.getColor() : this.getTextColor());
        this.getFont().draw((Batch)batch, this.getGlyph(), this.getTextX(), this.getTextY());
        batch.end();
    }

    @Override
    public boolean hover(float x, float y) {
        if (!this.contains(x, y)) {
            this.active = false;
            return false;
        }
        this.active = true;
        return true;
    }

    @Override
    public Color getAltColor() {
        return this.altColor;
    }

    @Override
    public void setAltColor(Color altColor) {
        this.altColor = altColor;
    }
}

