/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client.ui;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.utils.viewport.Viewport;
import grymV2.game.client.ui.UIElement;
import java.util.ArrayList;

public class Layout<T extends UIElement>
implements UIElement {
    private float x;
    private float y;
    private float width;
    private float height;
    private ArrayList<ArrayList<T>> shapes = new ArrayList();
    private int li;
    private int lj;

    public Layout(Viewport viewport) {
        this(viewport.getWorldWidth(), viewport.getWorldHeight());
    }

    public Layout(float width, float height) {
        this.shapes.add(new ArrayList());
        this.li = -1;
        this.lj = -1;
        this.x = 0.0f;
        this.y = 0.0f;
        this.width = width;
        this.height = height;
    }

    public ArrayList<ArrayList<T>> getShapes() {
        return this.shapes;
    }

    private void setDimensions() {
        int jsize;
        int itemsX = this.shapes.size();
        float spaceX = this.getWidth() * 0.1f / (float)(itemsX + 1);
        float itemWidth = this.getWidth() * 0.9f / (float)itemsX;
        int itemsY = 0;
        for (int i = 0; i < itemsX; ++i) {
            jsize = this.shapes.get(i).size();
            if (jsize <= itemsY) continue;
            itemsY = jsize;
        }
        float spacingY = this.getHeight() * 0.1f / (float)(itemsY + 1);
        float itemHeight = this.getHeight() * 0.9f / (float)itemsY;
        float offsetX = this.getX() + spaceX;
        float offsetY = this.getY() + spacingY;
        for (int i = 0; i < itemsX; ++i) {
            jsize = this.shapes.get(i).size();
            for (int j = 0; j < jsize; ++j) {
                UIElement shape = (UIElement)this.shapes.get(i).get(j);
                if (shape != null) {
                    shape.setX(offsetX);
                    shape.setY(offsetY);
                    shape.setWidth(itemWidth);
                    shape.setHeight(itemHeight);
                }
                offsetY += itemHeight + spacingY;
            }
            offsetX += itemWidth + spaceX;
            offsetY = this.getY() + spacingY;
        }
    }

    @Override
    public void draw(ShapeRenderer shapeRenderer, SpriteBatch batch, Camera camera) {
        this.setDimensions();
        for (int i = 0; i < this.shapes.size(); ++i) {
            ArrayList<T> shapesColumn = this.shapes.get(i);
            for (int j = 0; j < shapesColumn.size(); ++j) {
                UIElement shape = (UIElement)shapesColumn.get(j);
                if (shape == null) continue;
                shape.draw(shapeRenderer, batch, camera);
            }
        }
    }

    private void put(T shape, Positions pos) {
        int i = this.li;
        int j = this.lj;
        switch (pos) {
            case BELOW: {
                --j;
                break;
            }
            case ABOVE: {
                ++j;
                break;
            }
            case RIGHT: {
                ++i;
                break;
            }
            case LEFT: {
                --i;
                break;
            }
        }
        if (i < 0) {
            if (this.shapes.get(0).size() > 0) {
                this.shapes.add(0, new ArrayList());
            }
            i = 0;
        } else if (i > this.shapes.size()) {
            this.shapes.add(new ArrayList());
        }
        int jsize = this.shapes.get(i).size();
        if (j < 1) {
            j = 0;
            if (jsize > 0 && this.shapes.get(i).get(j) == null) {
                this.shapes.get(i).set(j, shape);
            } else {
                this.shapes.get(i).add(j, shape);
            }
        } else if (jsize - 1 < j) {
            for (int n = jsize; n < j; ++n) {
                this.shapes.get(i).add(n, null);
            }
            this.shapes.get(i).add(j, shape);
        } else {
            this.shapes.get(i).set(j, shape);
        }
        this.setDimensions();
        this.li = i;
        this.lj = j;
    }

    public void add(T shape) {
        this.put(shape, Positions.BELOW);
    }

    public void below(T shape) {
        this.put(shape, Positions.BELOW);
    }

    public void above(T shape) {
        this.put(shape, Positions.ABOVE);
    }

    public void right(T shape) {
        this.put(shape, Positions.RIGHT);
    }

    public void left(T shape) {
        this.put(shape, Positions.LEFT);
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public void setX(float x) {
        this.x = x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public void setY(float y) {
        this.y = y;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(float width) {
        this.width = width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(float height) {
        this.height = height;
    }

    public void centreLayout(Viewport viewport) {
        float hww = viewport.getWorldWidth() / 2.0f;
        float hwh = viewport.getWorldHeight() / 2.0f;
        this.centreLayout(hww, hwh);
    }

    public void centreLayout(float x, float y) {
        float htw = this.width / 2.0f;
        float xmhtw = x - htw;
        this.setX(xmhtw > 0.0f ? xmhtw : 0.0f);
        float hth = this.height / 2.0f;
        float ymhth = y - hth;
        this.setY(ymhth > 0.0f ? ymhth : 0.0f);
    }

    private static enum Positions {
        ABOVE,
        BELOW,
        LEFT,
        RIGHT;

    }
}

