/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client.input;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractInputHandler {
    private int mouseX;
    private int mouseY;
    private EnumMap<MousePositions, Integer> leftClickPos;
    private boolean leftClicked;
    private boolean CTRL;
    final int[] keysEnabled;
    private HashMap<Integer, Boolean> keysActive;
    private HashMap<Integer, EnumMap<MousePositions, Integer>> clickActive;

    public AbstractInputHandler(int[] keysEnabled) {
        this.keysEnabled = keysEnabled;
        this.keysActive = new HashMap();
        this.clickActive = new HashMap();
        this.leftClickPos = new EnumMap(MousePositions.class);
        this.leftClicked = false;
        this.CTRL = false;
        for (int k : keysEnabled) {
            this.keysActive.put(k, false);
        }
    }

    public boolean setMousePos(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        return true;
    }

    public int[] getMousePos() {
        return new int[]{this.mouseX, this.mouseY};
    }

    public void setScroll(float scrollX, float scrollY) {
    }

    public boolean leftClick(Boolean event) {
        if (event.booleanValue() && !this.leftClicked) {
            this.leftClickPos.put(MousePositions.STARTX, this.mouseX);
            this.leftClickPos.put(MousePositions.STARTY, this.mouseY);
        } else if (!event.booleanValue() && this.leftClicked) {
            this.leftClickPos.put(MousePositions.ENDX, this.mouseX);
            this.leftClickPos.put(MousePositions.ENDY, this.mouseY);
            this.clickActive.put(0, new EnumMap<MousePositions, Integer>(this.leftClickPos));
        }
        this.leftClicked = event;
        return true;
    }

    public boolean rightClick(Boolean event) {
        return false;
    }

    public boolean click(int button, Boolean event) {
        switch (button) {
            case 0: {
                return this.leftClick(event);
            }
            case 1: {
                return this.rightClick(event);
            }
        }
        return false;
    }

    public HashMap<Integer, EnumMap<MousePositions, Integer>> getClicks() {
        return this.clickActive;
    }

    public void setCTRL(Boolean event) {
        this.CTRL = event;
    }

    public boolean getCTRL() {
        return this.CTRL;
    }

    public boolean setKey(int key, Boolean event) {
        System.out.println();
        this.keysActive.put(key, event);
        return this.keysActive.containsKey(key);
    }

    public ArrayList<Integer> getKeys() {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (Map.Entry<Integer, Boolean> e : this.keysActive.entrySet()) {
            if (!e.getValue().booleanValue()) continue;
            keys.add(e.getKey());
        }
        return keys;
    }

    public void handle() {
        this.handleLogic(this.getMousePos(), this.getKeys(), this.getClicks());
        for (int k : this.keysActive.keySet()) {
            this.keysActive.put(k, false);
        }
        this.clickActive = new HashMap();
    }

    public abstract void handleLogic(int[] var1, ArrayList<Integer> var2, HashMap<Integer, EnumMap<MousePositions, Integer>> var3);

    public static enum MousePositions {
        STARTX,
        STARTY,
        ENDX,
        ENDY;

    }
}

