/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.ScreenAdapter;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.ScreenUtils;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import grymV2.game.client.AssetManager;
import grymV2.game.client.Cain;
import grymV2.game.client.input.AbstractInputHandler;
import grymV2.game.client.ui.ImageButton;
import grymV2.game.client.ui.Layout;
import grymV2.game.client.ui.MenuShape;
import grymV2.game.client.ui.TextBox;
import grymV2.game.config.TextureMap;
import grymV2.game.config.WorldEnabled;
import grymV2.game.grid.Grid;
import grymV2.game.grid.GridLayers;
import grymV2.game.world.GameObject;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;

public class CainsLeftFoot
extends ScreenAdapter {
    private final int VIEWPORT_HEIGHT;
    private final int GAME_VIEWPORT_WIDTH;
    private final int UI_VIEWPORT_WIDTH;
    private final float UI_RATIO;
    private final float GAME_RATIO;
    final Cain manager;
    final Grid grid;
    private float delta;
    private float time;
    private final OrthographicCamera masterCamera = new OrthographicCamera();
    private final AssetManager assetManager;
    private final FitViewport uiViewport;
    private final SpriteBatch uiBatch;
    private final BitmapFont uiFont;
    private final ShapeRenderer uiShapeRenderer;
    private final FitViewport gameViewport;
    private final SpriteBatch gameBatch;
    private final BitmapFont gameFont;
    private final ShapeRenderer gameShapeRenderer;
    private Layout<Layout<? extends MenuShape>> masterBox;
    private Layout<TextBox> stats;
    private Layout<ImageButton> placeables;
    private Layout<TextBox> info;
    private ArrayList<ImageButton> buttons;
    private TextBox statsBox;
    private TextBox infoBox;
    private ImageButton selected;

    public CainsLeftFoot(Cain manager, Grid grid) {
        this.masterCamera.setToOrtho(false, 1920.0f, 1080.0f);
        this.assetManager = new AssetManager();
        this.manager = manager;
        this.grid = grid;
        this.GAME_VIEWPORT_WIDTH = this.grid.getDimensionX();
        this.VIEWPORT_HEIGHT = this.grid.getDimensionY();
        this.UI_RATIO = manager.game.settings.getUIRatio();
        this.GAME_RATIO = 1.0f - this.UI_RATIO;
        this.UI_VIEWPORT_WIDTH = Math.round((float)this.GAME_VIEWPORT_WIDTH * (this.UI_RATIO / this.GAME_RATIO));
        this.uiViewport = new FitViewport(this.UI_VIEWPORT_WIDTH, (float)this.VIEWPORT_HEIGHT, this.masterCamera);
        this.uiBatch = new SpriteBatch();
        this.uiShapeRenderer = new ShapeRenderer();
        this.uiFont = new BitmapFont();
        this.uiFont.setUseIntegerPositions(false);
        this.uiFont.getData().setScale(this.uiViewport.getWorldHeight() / (float)Gdx.graphics.getHeight());
        this.gameViewport = new FitViewport(this.GAME_VIEWPORT_WIDTH, (float)this.VIEWPORT_HEIGHT, this.masterCamera);
        this.gameBatch = new SpriteBatch();
        this.gameFont = new BitmapFont();
        this.gameShapeRenderer = new ShapeRenderer();
        this.gameFont.setUseIntegerPositions(false);
        this.gameFont.getData().setScale(this.gameViewport.getWorldHeight() / (float)Gdx.graphics.getHeight());
        this.delta = 0.0f;
        this.mkUI();
        this.mkGAM();
    }

    private void mkGAM() {
    }

    private void mkUI() {
        FitViewport viewport = this.uiViewport;
        this.masterBox = new Layout(viewport);
        this.masterBox.centreLayout(viewport);
        this.stats = new Layout(viewport);
        this.info = new Layout(viewport);
        this.placeables = new Layout(viewport);
        this.buttons = new ArrayList();
        WorldEnabled.Building[] WEBv = WorldEnabled.Building.values();
        Vector2 layoutSize = this.howLongIsAPieceOfVector2(WEBv.length);
        int pointer = -1;
        int i = 0;
        while ((float)i < layoutSize.x) {
            int j = 0;
            while ((float)j < layoutSize.y && ++pointer < WEBv.length) {
                ImageButton button = new ImageButton(new Texture(TextureMap.valueOf(WEBv[pointer].toString()).getTexture()));
                this.buttons.add(button);
                if (j == 0) {
                    this.placeables.left(button);
                } else {
                    this.placeables.add(button);
                }
                ++j;
            }
            ++i;
        }
        this.statsBox = new TextBox(this.uiFont);
        this.statsBox.setText("");
        this.stats.add(this.statsBox);
        this.infoBox = new TextBox(this.uiFont);
        this.infoBox.setText("Nothing selected");
        this.info.add(this.infoBox);
        this.masterBox.add(this.stats);
        this.masterBox.add(this.placeables);
        this.masterBox.add(this.info);
    }

    private Vector2 howLongIsAPieceOfVector2(int len) {
        float sq = (float)Math.ceil(Math.sqrt(len));
        float x = sq > 3.0f ? 3.0f : sq;
        Vector2 v = new Vector2(x, (float)Math.ceil((float)len / x));
        return v;
    }

    public float getDelta() {
        return this.delta;
    }

    @Override
    public void render(float delta) {
        this.delta = delta;
        ScreenUtils.clear(this.manager.game.settings.getUIForeground());
        this.input();
        this.logic();
        this.draw();
    }

    public void input() {
        this.manager.handleInput();
    }

    public FitViewport getGameViewport() {
        return this.gameViewport;
    }

    public FitViewport getUiViewport() {
        return this.uiViewport;
    }

    public void logic() {
        this.time = this.manager.game.getTimer();
        if (this.time > 300.0f) {
            this.endGame();
        }
    }

    public void draw() {
        this.doGAM();
        this.doUI();
    }

    private void doGAM() {
        this.gameViewport.apply(true);
        this.gameShapeRenderer.setProjectionMatrix(this.gameViewport.getCamera().combined);
        this.gameShapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.gameShapeRenderer.rect(0.0f, 0.0f, this.gameViewport.getWorldWidth(), this.gameViewport.getWorldHeight());
        this.gameShapeRenderer.end();
        this.gameBatch.setProjectionMatrix(this.gameViewport.getCamera().combined);
        this.gameBatch.begin();
        byte gridSizeX = this.grid.getSize().getX();
        byte gridSizeY = this.grid.getSize().getY();
        for (byte i = 0; i < gridSizeX; i = (byte)(i + 1)) {
            for (byte j = 0; j < gridSizeY; j = (byte)(j + 1)) {
                for (GridLayers layer : GridLayers.values()) {
                    GameObject layerObject = this.grid.getTile(i, j).getLayer(layer);
                    if (layerObject == null) continue;
                    Sprite layerSprite = this.assetManager.getSprite(layerObject.getTexture().getTexture());
                    layerSprite.setSize(1.0f, 1.0f);
                    layerSprite.setX(i);
                    layerSprite.setY(j);
                    layerSprite.draw(this.gameBatch);
                }
            }
        }
        this.gameBatch.end();
    }

    private void doUI() {
        this.uiViewport.apply(true);
        String stats = "Time: " + this.time + "\n\n";
        this.statsBox.setText(stats);
        this.masterBox.draw(this.uiShapeRenderer, this.uiBatch, this.uiViewport.getCamera());
    }

    @Override
    public void resize(int width, int height) {
        int endpoint = this.resizeViewport(this.uiViewport, this.UI_RATIO, 0, width, height);
        this.resizeViewport(this.gameViewport, this.GAME_RATIO, endpoint, width, height);
        this.uiViewport.apply(true);
        this.gameViewport.apply(true);
    }

    private int resizeViewport(Viewport viewport, float ratio, int start, int width, int height) {
        Vector2 scaled = Scaling.fit.apply(viewport.getWorldWidth(), viewport.getWorldHeight(), (float)width * ratio, height);
        int viewportWidth = Math.round(scaled.x);
        int viewportHeight = Math.round(scaled.y);
        viewport.setScreenBounds(start, (height - viewportHeight) / 2, viewportWidth, viewportHeight);
        return viewportWidth;
    }

    @Override
    public void dispose() {
        this.uiBatch.dispose();
        this.uiShapeRenderer.dispose();
        this.uiFont.dispose();
        this.gameBatch.dispose();
        this.gameFont.dispose();
        this.gameShapeRenderer.dispose();
    }

    @Override
    public void pause() {
        this.manager.pause();
    }

    public void endGame() {
        this.manager.endGame();
    }

    public void handleLogic(int[] mousePos, ArrayList<Integer> keys, HashMap<Integer, EnumMap<AbstractInputHandler.MousePositions, Integer>> clicks) {
        for (int keycode : keys) {
            switch (keycode) {
                case 44: {
                    this.pause();
                    break;
                }
            }
        }
    }
}

