/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game.client;

import com.badlogic.gdx.ScreenAdapter;
import grymV2.game.Adam;
import grymV2.game.ScreenStates;
import grymV2.game.client.CainsLeftEye;
import grymV2.game.client.CainsLeftFoot;
import grymV2.game.client.CainsLeftHand;
import grymV2.game.client.CainsLeftKnee;
import grymV2.game.client.input.EndInputHandler;
import grymV2.game.client.input.GameInputHandler;
import grymV2.game.client.input.GlobalInputListener;
import grymV2.game.client.input.MenuInputHandler;
import grymV2.game.client.input.PauseInputHandler;
import grymV2.game.grid.Grid;

public class Cain {
    final Adam game;
    final Grid grid;
    private GlobalInputListener input;
    private ScreenAdapter activeScreen;

    public Cain(Adam game, Grid grid) {
        this.game = game;
        this.grid = grid;
        this.activeScreen = null;
    }

    public void create() {
        this.input = new GlobalInputListener(this);
    }

    public void setScreen(ScreenStates screen) {
        switch (screen) {
            case MENU: {
                this.activeScreen = new CainsLeftEye(this, this.grid);
                this.input.setHandler(new MenuInputHandler((CainsLeftEye)this.activeScreen));
                this.game.setScreen(this.activeScreen);
                break;
            }
            case GAME: {
                this.activeScreen = new CainsLeftFoot(this, this.grid);
                this.input.setHandler(new GameInputHandler((CainsLeftFoot)this.activeScreen));
                this.game.setScreen(this.activeScreen);
                break;
            }
            case PAUSE: {
                this.activeScreen = new CainsLeftKnee(this, this.grid);
                this.input.setHandler(new PauseInputHandler((CainsLeftKnee)this.activeScreen));
                this.game.setScreen(this.activeScreen);
                break;
            }
            case END: {
                this.activeScreen = new CainsLeftHand(this, this.grid);
                this.input.setHandler(new EndInputHandler((CainsLeftHand)this.activeScreen));
                this.game.setScreen(this.activeScreen);
                break;
            }
        }
    }

    public void handleInput() {
        this.input.handle();
    }

    public void pause() {
        this.game.setState(ScreenStates.PAUSE);
    }

    public void startGame() {
        this.game.setState(ScreenStates.GAME);
        this.game.serverThreaded.startGame();
    }

    public void endGame() {
        this.AmIMyBrothersKeeper();
    }

    private void AmIMyBrothersKeeper() {
        this.game.setState(ScreenStates.END);
    }

    public void quitGame() {
        this.game.exit();
    }

    public void resume() {
        this.game.setState(ScreenStates.GAME);
    }
}

