/*
 * Decompiled with CFR 0.152.
 */
package grymV2.game;

import com.badlogic.gdx.Game;
import grymV2.game.Eve;
import grymV2.game.ScreenStates;
import grymV2.game.client.Cain;
import grymV2.game.config.Settings;
import grymV2.game.server.Abel;
import java.util.Date;

public class Adam
extends Game {
    private Eve loader;
    public Settings settings = new Settings();
    protected Cain client;
    public Abel serverThreaded;
    private float hackTimer = 0.0f;
    private float hackTimerLast = 0.0f;

    public Adam() {
        this.loader = new Eve(this);
    }

    @Override
    public void create() {
        this.client.create();
        this.client.setScreen(ScreenStates.MENU);
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void dispose() {
        this.loader.dispose();
        super.dispose();
    }

    public void setState(ScreenStates state) {
        switch (state) {
            case MENU: {
                break;
            }
            case GAME: {
                if (!this.serverThreaded.isPaused()) break;
                this.serverThreaded.unpause();
                break;
            }
            case PAUSE: {
                this.serverThreaded.pause();
                break;
            }
            case END: {
                this.serverThreaded.endGame();
                break;
            }
        }
        this.client.setScreen(state);
    }

    public synchronized float getTimer() {
        Date date = new Date((long)(this.serverThreaded.getTime() / 1000000.0f));
        float dateseconds = date.getMinutes() * 60 + date.getSeconds();
        if (dateseconds > this.hackTimerLast) {
            this.hackTimerLast = dateseconds;
            this.hackTimer += 1.0f;
        }
        return this.hackTimer;
    }

    public void exit() {
        this.dispose();
        System.exit(0);
    }
}

